--
-- VX_Sp_IsDoNotCallPhone
--
-- Verify if a given phone number is a "Do Not Call" phone by the options defined in the installation table
--
--

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_Sp_IsDoNotCallPhone]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].VX_Sp_IsDoNotCallPhone
GO

CREATE PROCEDURE VX_Sp_IsDoNotCallPhone
	@phoneNumber varchar(20) 
AS
BEGIN

	-- Fetch the DNC Settings from installation table	
	DECLARE @dncFlag int
	SET @dncFlag= (Select top 1 insvalue From Installation where INSSECTION='OPTIONS' and INSIDENT='DNC')
	IF (@dncFlag IS NULL) SET @dncFlag = 1
	
	-- case 0, do not check
	IF ( @dncFlag = 0 )
	BEGIN
		SELECT 0
		return
	END
	
	-- case 1, enforce
	IF ( @dncFlag = 1 )
	BEGIN
		SELECT COUNT(Phone) FROM DoNotCallList WHERE Phone = @phoneNumber;
		return
	END
	
	
	--case 2  - enforce with  registration date
	IF ( @dncFlag = 2 )
	BEGIN
		-- Pre calculate the DNC expiration date
		DECLARE @dncExpirationPeriod int
		SET @dncExpirationPeriod= (Select top 1 insvalue From Installation where INSSECTION='OPTIONS' and INSIDENT='DNCRegistrationExpiringPeriod')
		IF (@dncExpirationPeriod IS NULL) SET @dncExpirationPeriod = 36

		DECLARE @dncExpirationDate datetime;
		SET @dncExpirationDate = DATEADD (month , -@dncExpirationPeriod , GETUTCDATE() )
	
		SELECT COUNT(Phone) FROM DoNotCallList WHERE Phone = @phoneNumber AND RegistrationDate > @dncExpirationDate
		return
	END
		
	--case else
	SELECT 0

END
GO
